package some;

import java.util.HashMap;
import java.util.Map;

public class UserInfo {
	private int id;
	private String gender;
	private String firstName;
	private String lastName;
	private String mailAddress;
	private Map<String, String> workingHours = new HashMap<String, String>();

	public String toString() {
		StringBuffer buff = new StringBuffer("UserInfo\t");
		buff.append("id=" + String.valueOf(getId()) + ", ");
		buff.append("gender=" + getGender() + ", ");
		buff.append("firstName=" + getFirstName() + ", ");
		buff.append("lastName=" + getLastName());

		buff.append(" Ǝ ");
		for (String month : workingHours.keySet()) {
			Object value = workingHours.get(month);
			buff.append(String.format(" %s=%s", month, value));
		}
		return buff.toString();
	}

	public void setId(int id) {
		this.id = id;
	}
	public int getId() {
		return id;
	}
	public void setGender(String gender) {
		this.gender = gender;
	}
	public String getGender() {
		return gender;
	}
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}
	public String getFirstName() {
		return firstName;
	}
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}
	public String getLastName() {
		return lastName;
	}
	public void setMailAddress(String mailAddress) {
		this.mailAddress = mailAddress;
	}
	public String getMailAddress() {
		return mailAddress;
	}

	public void setWorkingHours(Map<String, String> workingHours) {
		this.workingHours = workingHours;
	}
	public Map<String, String> getWorkingHours() {
		return workingHours;
	}


}
